/*
 * Decompiled with CFR 0.152.
 */
import java.util.Observable;

public class Clock
extends Observable
implements Runnable {
    long ivLocalTimeOffset;
    long ivClockMillis;
    Thread ivClockRunner = new Thread(this);
    boolean ivRunning = false;

    public Clock() {
        this.ivClockRunner.start();
    }

    public synchronized String toString() {
        int n = this.GetClockTime();
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        int n4 = n % 60;
        return n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InternalError(interruptedException.getMessage());
            }
            Clock clock = this;
            synchronized (clock) {
                if (this.ivRunning) {
                    this.ivClockMillis = System.currentTimeMillis() - this.ivLocalTimeOffset;
                    this.setChanged();
                    this.notifyObservers(new ClockEvent(1, this.GetClockTime()));
                }
            }
        }
    }

    synchronized int GetClockTime() {
        return (int)(this.ivClockMillis / 1000L);
    }

    public synchronized void Start() {
        this.setChanged();
        this.notifyObservers(new ClockEvent(2, this.GetClockTime()));
        this.ivLocalTimeOffset = System.currentTimeMillis() - this.ivClockMillis;
        this.ivRunning = true;
    }

    public synchronized void Stop() {
        this.ivRunning = false;
        this.ivClockMillis = System.currentTimeMillis() - this.ivLocalTimeOffset;
        this.setChanged();
        this.notifyObservers(new ClockEvent(3, this.GetClockTime()));
    }

    public synchronized void Reset() {
        this.Stop();
        this.ivClockMillis = 0L;
    }
}

