/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class MessageBox
extends Dialog {
    public static final int NOICON = -1;
    public static final int INFOICON = 0;
    public static final int FRAGEICON = 1;
    public static final int AUSRUFEICON = 2;
    public static final int STOPICON = 3;
    protected Icon[] icons;
    protected Frame parentFrame;
    protected Button[] button;
    protected MultiLineLabel text;
    protected Font sysFont = new Font("Helvetica", 0, 12);

    public MessageBox(Frame frame) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        this.loadIcons();
    }

    public MessageBox(Frame frame, Applet applet) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        this.loadIcons(applet);
    }

    public MessageBox(Frame frame, URL[] uRLArray) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        if (uRLArray != null) {
            try {
                this.icons = new Icon[uRLArray.length];
                int n = 0;
                while (n < uRLArray.length) {
                    this.icons[n] = new Icon(uRLArray[n]);
                    ++n;
                }
                return;
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                return;
            }
        }
    }

    public MessageBox(Frame frame, Image[] imageArray) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        if (imageArray != null) {
            this.icons = new Icon[imageArray.length];
            int n = 0;
            while (n < imageArray.length) {
                this.icons[n] = new Icon(imageArray[n]);
                ++n;
            }
        }
    }

    public MessageBox(Frame frame, String string, String string2, String[] stringArray, int n) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        this.loadIcons();
        this.newContents(string, string2, stringArray, n);
    }

    public MessageBox(Frame frame, String string, String string2, String[] stringArray, int n, Applet applet) {
        super(frame, true);
        this.parentFrame = frame;
        ((Component)this).setFont(this.sysFont);
        this.loadIcons(applet);
        this.newContents(string, string2, stringArray, n);
    }

    public MessageBox(Frame frame, String string, String string2) {
        super(frame, true);
        this.parentFrame = frame;
        String[] stringArray = new String[]{"OK"};
        ((Component)this).setFont(this.sysFont);
        this.newContents(string, string2, stringArray, -1);
    }

    public void newContents(String string, String string2, String[] stringArray, int n) {
        ((Component)this).hide();
        this.removeAll();
        this.setTitle(string);
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 15, 15));
        if (this.icons != null && n < this.icons.length && n > -1) {
            panel.add(this.icons[n]);
        }
        this.text = new MultiLineLabel(string2, 0, 0);
        panel.add(this.text);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1, 15, 15));
        this.button = new Button[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.button[n2] = new Button(stringArray[n2]);
            panel2.add(this.button[n2]);
            ++n2;
        }
        this.add("South", panel2);
        this.resize(this.preferredSize());
        this.pack();
    }

    public void newContents(String string, String string2, int n) {
        String[] stringArray = new String[]{"OK"};
        this.newContents(string, string2, stringArray, n);
    }

    public boolean action(Event event, Object object) {
        int n = 0;
        while (n < this.button.length) {
            if (event.target == this.button[n]) {
                ((Component)this).hide();
                this.dispose();
                return true;
            }
            ++n;
        }
        return super.action(event, object);
    }

    public boolean goFocus(Event event, Object object) {
        if (this.button.length > 0) {
            this.button[0].requestFocus();
        }
        return true;
    }

    protected void loadIcons() {
        try {
            URL uRL = new URL("file://INFO.gif");
            URL uRL2 = new URL("file://FRAGE.gif");
            URL uRL3 = new URL("file://AUSRUFE.gif");
            URL uRL4 = new URL("file://STOP.gif");
            this.icons = new Icon[4];
            this.icons[0] = new Icon(uRL);
            this.icons[1] = new Icon(uRL2);
            this.icons[2] = new Icon(uRL3);
            this.icons[3] = new Icon(uRL4);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("MessageBox - konnte Images nicht finden");
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return;
        }
    }

    protected void loadIcons(Applet applet) {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = applet.getImage(applet.getCodeBase(), "INFO.gif");
        mediaTracker.addImage(image, 0);
        Image image2 = applet.getImage(applet.getCodeBase(), "FRAGE.gif");
        mediaTracker.addImage(image2, 0);
        Image image3 = applet.getImage(applet.getCodeBase(), "AUSRUFE.gif");
        mediaTracker.addImage(image3, 0);
        Image image4 = applet.getImage(applet.getCodeBase(), "STOP.gif");
        mediaTracker.addImage(image4, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError(interruptedException.getMessage());
        }
        this.icons = new Icon[4];
        this.icons[0] = new Icon(image);
        this.icons[1] = new Icon(image2);
        this.icons[2] = new Icon(image3);
        this.icons[3] = new Icon(image4);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        String[] stringArray2 = new String[]{"Button1", "Button2"};
        MessageBox messageBox = new MessageBox(frame, "Titel", "Das ist eine Meldung\nZweite Zeile", stringArray2, 1);
        messageBox.show();
    }

    private static Frame FindFrame(Applet applet) {
        Container container = applet;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public static void DoErrorMessage(String string, String string2, Applet applet) {
        MessageBox messageBox = null;
        String[] stringArray = new String[]{"OK"};
        messageBox = applet == null ? new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 3) : new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 3, applet);
        messageBox.show();
    }

    public static void DoWarningMessage(String string, String string2, Applet applet) {
        MessageBox messageBox = null;
        String[] stringArray = new String[]{"OK"};
        messageBox = applet == null ? new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 2) : new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 2, applet);
        messageBox.show();
    }

    public static void DoInfoMessage(String string, String string2, Applet applet) {
        MessageBox messageBox = null;
        String[] stringArray = new String[]{"OK"};
        messageBox = applet == null ? new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 0) : new MessageBox(MessageBox.FindFrame(applet), string, string2, stringArray, 0, applet);
        messageBox.show();
    }
}

