/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] zeilen;
    protected int anzZeilen;
    protected int randBreite;
    protected int randHoehe;
    protected int zeichensatzHoehe;
    protected int zeichensatzFreiraum;
    protected int[] zeilenBreite;
    protected int maxBreite;
    protected int ausrichtung = 0;

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.newLabel(string);
        this.randBreite = n;
        this.randHoehe = n2;
        this.ausrichtung = n3;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setTextfarbe(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAusrichtung(int n) {
        this.ausrichtung = n;
        this.repaint();
    }

    public void setRandBreite(int n) {
        this.randBreite = n;
        this.repaint();
    }

    public void setRandHoehe(int n) {
        this.randBreite = n;
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension preferredSize() {
        return new Dimension(this.maxBreite + 2 * this.randBreite, this.anzZeilen * this.zeichensatzHoehe + 2 * this.randHoehe);
    }

    public Dimension minimumSize() {
        return new Dimension(this.maxBreite, this.anzZeilen * this.zeichensatzHoehe);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        int n = this.zeichensatzFreiraum + (dimension.height - this.anzZeilen * this.zeichensatzHoehe) / 2;
        int n2 = 0;
        while (n2 < this.anzZeilen) {
            int n3;
            switch (this.ausrichtung) {
                case 0: {
                    n3 = this.randBreite;
                    break;
                }
                default: {
                    n3 = (dimension.width - this.zeilenBreite[n2]) / 2;
                }
            }
            graphics.drawString(this.zeilen[n2], n3, n);
            ++n2;
            n += this.zeichensatzHoehe;
        }
    }

    protected void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.anzZeilen = stringTokenizer.countTokens();
        this.zeilen = new String[this.anzZeilen];
        this.zeilenBreite = new int[this.anzZeilen];
        int n = 0;
        while (n < this.anzZeilen) {
            this.zeilen[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.zeichensatzHoehe = fontMetrics.getHeight();
        this.zeichensatzFreiraum = fontMetrics.getAscent();
        this.maxBreite = 0;
        int n = 0;
        while (n < this.anzZeilen) {
            this.zeilenBreite[n] = fontMetrics.stringWidth(this.zeilen[n]);
            if (this.zeilenBreite[n] > this.maxBreite) {
                this.maxBreite = this.zeilenBreite[n];
            }
            ++n;
        }
    }
}

