/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Observable;
import java.util.Observer;

public final class Polyomino
extends Applet
implements Observer,
Runnable {
    static final int cSolutionMode = 0;
    static final int cSituationMode = 1;
    static final int cNavigatePageSize = 10;
    Solver ivSolver;
    Thread ivSolveThread;
    Choice ivDisplayModeChoice;
    Button ivRefreshSituation;
    Scrollbar ivNavigateBar;
    SolutionView ivSolutionView;
    int ivDisplayMode = 0;
    int ivVersion = 1;
    int ivNumSolutions;
    int ivSupposedSBValue;
    int ivSupposedSBMax;
    static String[] ivMenuText = new String[]{"Every solution", "Manually"};
    static int ivSBMaxBugCorrection;

    public void init() {
        String string = this.getParameter("Version");
        if (string != null) {
            this.ivVersion = Integer.parseInt(string);
        }
        int n = 0;
        super.init();
        this.setLayout(null);
        this.ivSolver = new Solver(this, false, true);
        if (this.ivSolver.GetStatus() == 1) {
            StatusView statusView = new StatusView(this.ivSolver, Color.lightGray);
            this.add(statusView);
            statusView.reshape(0, 0, this.size().width, 48);
            n += statusView.size().height;
            Panel panel = new Panel();
            panel.setBackground(Color.lightGray);
            panel.setLayout(new FlowLayout(0));
            Label label = new Label("Update display");
            label.setAlignment(2);
            panel.add(label);
            this.ivDisplayModeChoice = new Choice();
            int n2 = 0;
            while (n2 < ivMenuText.length) {
                this.ivDisplayModeChoice.addItem(ivMenuText[n2]);
                ++n2;
            }
            panel.add(this.ivDisplayModeChoice);
            this.ivRefreshSituation = new Button("Refresh");
            panel.add(this.ivRefreshSituation);
            this.add(panel);
            panel.reshape(0, n, this.size().width, panel.preferredSize().height);
            this.ivRefreshSituation.disable();
            n += panel.size().height;
            this.ivSolutionView = new SolutionView(this.ivSolver);
            this.add(this.ivSolutionView);
            this.ivSolver.addObserver(this);
            this.ivNavigateBar = new Scrollbar(0, this.ivSupposedSBValue, 0, 0, this.ivSupposedSBMax);
            this.add(this.ivNavigateBar);
            this.ExamineBuggyScrollbar(this.ivNavigateBar);
            this.ivNavigateBar.setPageIncrement(10);
            this.ivSolutionView.reshape(0, n, this.size().width, this.size().height - n - this.ivNavigateBar.preferredSize().height);
            this.ivNavigateBar.reshape(0, n += this.ivSolutionView.size().height, this.size().width, this.ivNavigateBar.preferredSize().height);
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void start() {
        super.start();
        if (this.ivSolveThread == null) {
            this.ivSolveThread = new Thread(this);
            this.ivSolveThread.start();
        }
    }

    public void stop() {
        this.ivSolver.ivStopSolving = true;
        if (this.ivSolveThread != null) {
            this.ivSolveThread = null;
        }
        super.stop();
    }

    public void run() {
        if (this.ivSolver.GetStatus() == 1) {
            this.ivSolver.Solve();
        }
    }

    public String getAppletInfo() {
        return "Solve polyomino puzzles, written by Gerard Putter";
    }

    void GoToNumber(int n) {
        if (this.ivSolver.GetNumSolutions() == 0) {
            return;
        }
        if (n < 1) {
            n = 1;
        } else {
            int n2 = this.ivSolver.GetNumSolutions();
            if (n > n2) {
                n = n2;
            }
        }
        this.ivSolutionView.SetSolution((PieceInPuzzle[])this.ivSolver.ivSolutions.elementAt(n - 1), n);
    }

    public boolean action(Event event, Object object) {
        boolean bl = true;
        if (event.target == this.ivDisplayModeChoice) {
            String string = (String)object;
            if (string.equals(ivMenuText[0])) {
                this.ivRefreshSituation.disable();
                this.ivNavigateBar.enable();
                this.SetDisplayMode(0);
                this.UpdateSolutionDisplay(true);
            } else if (string.equals(ivMenuText[1])) {
                this.DoShowSituation();
            }
        } else if (event.target == this.ivRefreshSituation) {
            this.ivSolutionView.SetSolution(this.ivSolver.CopyCurrentPiecesInPuzzle(), -1);
        } else {
            bl = super.action(event, object);
        }
        return bl;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.ivNavigateBar && this.GetDisplayMode() == 0) {
            if (event.arg != null) {
                int n;
                this.ivSupposedSBValue = n = ((Integer)event.arg).intValue();
                this.GoToNumber(n);
            }
            return true;
        }
        return super.handleEvent(event);
    }

    void DoShowSolution() {
        this.ivRefreshSituation.disable();
        this.ivNavigateBar.enable();
        this.SetDisplayMode(0);
        this.UpdateSolutionDisplay(true);
    }

    void DoShowSituation() {
        this.ivRefreshSituation.enable();
        this.ivNavigateBar.disable();
        this.SetDisplayMode(1);
        this.ivSolutionView.SetSolution(this.ivSolver.CopyCurrentPiecesInPuzzle(), -1);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Solver && ((SolverEvent)object).ivWhat == 2) {
            this.ivNumSolutions = ((SolverEvent)object).ivData;
            if (this.GetDisplayMode() == 0) {
                this.UpdateSolutionDisplay(false);
            }
        }
    }

    private void UpdateSolutionDisplay(boolean bl) {
        int n;
        if (this.ivNumSolutions == 0) {
            this.ivSolutionView.SetSolution(null, 0);
            return;
        }
        int n2 = n = this.ivSupposedSBValue;
        if (n >= this.ivSupposedSBMax) {
            n2 = this.ivNumSolutions;
        }
        this.ivSupposedSBMax = this.ivNumSolutions;
        this.ivNavigateBar.setValues(this.ivSupposedSBValue, 1, 1, this.ivSupposedSBMax + ivSBMaxBugCorrection);
        this.ivSupposedSBValue = n2;
        this.ivNavigateBar.setValue(this.ivSupposedSBValue);
        this.ivNavigateBar.setPageIncrement(10);
        if (n2 != n || bl) {
            this.ivSolutionView.SetSolution((PieceInPuzzle[])this.ivSolver.ivSolutions.elementAt(n2 - 1), n2);
        }
    }

    synchronized int GetDisplayMode() {
        return this.ivDisplayMode;
    }

    synchronized void SetDisplayMode(int n) {
        this.ivDisplayMode = n;
    }

    void ExamineBuggyScrollbar(Scrollbar scrollbar) {
        scrollbar.setValues(1, 1, 1, 100);
        scrollbar.setValue(100);
        if (scrollbar.getValue() != 100) {
            ivSBMaxBugCorrection = 1;
        }
        this.ivNavigateBar.setValues(this.ivSupposedSBValue, 0, 0, this.ivSupposedSBMax);
    }
}

