/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

final class SolutionView
extends Canvas {
    Solver ivSolver;
    int ivSolutionNo;
    PieceInPuzzle[] ivSolution;
    int ivBorderH = 20;
    int ivBorderV = 16;
    int ivLineThickness = 2;
    Color ivPieceLineColor = new Color(255, 0, 0);
    Color ivPieceFillColor = new Color(255, 255, 63);
    Color ivBackgroundColor = Color.lightGray;
    Color ivTextColor = Color.black;
    Color ivBoardFillColor = Color.white;
    Color ivSepLineColor = new Color(224, 224, 224);

    SolutionView(Solver solver) {
        this.ivSolver = solver;
        this.setBackground(this.ivBackgroundColor);
    }

    public synchronized void paint(Graphics graphics) {
        int n = this.CalcUnitSize();
        this.DrawEmptyPuzzle(graphics, n, this.ivSolutionNo <= 0);
        if (this.ivSolution != null) {
            this.DrawPiecesInPuzzle(graphics, n, this.ivSolutionNo > 0);
        }
        this.DrawSolutionNo(graphics, n);
    }

    void DrawEmptyPuzzle(Graphics graphics, int n, boolean bl) {
        Rectangle rectangle = new Rectangle();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n6 <= this.ivSolver.ivOplossingHoogte) {
            int n7 = 1;
            while (n7 <= this.ivSolver.ivOplossingBreedte) {
                int n8 = this.ivSolver.GeefRandVrijheid(n7, n6);
                if (n8 >= 0) {
                    this.PuzzleCoords2Canvas(n7, n6, n, rectangle);
                    n2 = rectangle.x;
                    n3 = rectangle.y;
                    n4 = n;
                    n5 = n;
                    graphics.setColor(this.ivPieceLineColor);
                    if ((n8 & 8) != 0) {
                        this.drawThickVLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y, n + this.ivLineThickness);
                        n2 += this.ivLineThickness;
                        n4 -= this.ivLineThickness;
                    }
                    if ((n8 & 1) != 0) {
                        this.drawThickHLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y, n + this.ivLineThickness);
                        n3 += this.ivLineThickness;
                        n5 -= this.ivLineThickness;
                    }
                    if ((n8 & 4) != 0) {
                        this.drawThickHLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y + n, n + this.ivLineThickness);
                    }
                    if ((n8 & 2) != 0) {
                        this.drawThickVLine(graphics, this.ivLineThickness, rectangle.x + n, rectangle.y, n + this.ivLineThickness);
                    }
                    if (bl) {
                        graphics.setColor(this.ivBoardFillColor);
                        graphics.fillRect(n2, n3, n4, n5);
                        graphics.setColor(this.ivSepLineColor);
                        if ((n8 & 8) == 0) {
                            this.drawThickVLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y + this.ivLineThickness, n - this.ivLineThickness);
                        }
                        if ((n8 & 1) == 0) {
                            this.drawThickHLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y, n + this.ivLineThickness);
                        }
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    void DrawPiecesInPuzzle(Graphics graphics, int n, boolean bl) {
        Point point = new Point(0, 0);
        Rectangle rectangle = new Rectangle();
        int n2 = 0;
        while (n2 < this.ivSolution.length) {
            PieceInPuzzle pieceInPuzzle = this.ivSolution[n2];
            int n3 = pieceInPuzzle.hetStukType.oppervlakte;
            int n4 = 0;
            while (n4 < n3) {
                pieceInPuzzle.GetXYOfSquareN(this.ivSolver, n4, point);
                this.PuzzleCoords2Canvas(point.x, point.y, n, rectangle);
                StukType stukType = pieceInPuzzle.hetStukType;
                byte by = stukType.ivVrijheid[n4];
                int n5 = rectangle.x;
                int n6 = rectangle.y;
                int n7 = n;
                int n8 = n;
                graphics.setColor(this.ivPieceLineColor);
                if ((by & 8) != 0) {
                    this.drawThickVLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y, n + this.ivLineThickness);
                    n5 += this.ivLineThickness;
                    n7 -= this.ivLineThickness;
                }
                if ((by & 1) != 0) {
                    this.drawThickHLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y, n + this.ivLineThickness);
                    n6 += this.ivLineThickness;
                    n8 -= this.ivLineThickness;
                }
                if (!bl) {
                    if ((by & 4) != 0) {
                        this.drawThickHLine(graphics, this.ivLineThickness, rectangle.x, rectangle.y + n, n + this.ivLineThickness);
                    }
                    if ((by & 2) != 0) {
                        this.drawThickVLine(graphics, this.ivLineThickness, rectangle.x + n, rectangle.y, n + this.ivLineThickness);
                    }
                }
                graphics.setColor(this.ivPieceFillColor);
                graphics.fillRect(n5, n6, n7, n8);
                ++n4;
            }
            ++n2;
        }
    }

    void DrawSolutionNo(Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle();
        this.PuzzleCoords2Canvas(1, 1, n, rectangle);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        rectangle.x = 0;
        rectangle.width = this.size().width;
        rectangle.y = rectangle.y + n + this.ivLineThickness;
        rectangle.height = fontMetrics.getHeight();
        graphics.setColor(this.ivTextColor);
        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.ivSolutionNo >= 0) {
            String string = String.valueOf(this.ivSolutionNo);
            graphics.drawString(string, (rectangle.width - fontMetrics.stringWidth(string)) / 2, rectangle.y + fontMetrics.getDescent() + fontMetrics.getAscent());
        }
    }

    void drawThickVLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n) {
            graphics.drawLine(n2 + n5, n3, n2 + n5, n3 + n4 - 1);
            ++n5;
        }
    }

    void drawThickHLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n) {
            graphics.drawLine(n2, n3 + n5, n2 + n4 - 1, n3 + n5);
            ++n5;
        }
    }

    void PuzzleCoords2Canvas(Point point, int n, Rectangle rectangle) {
        this.PuzzleCoords2Canvas(point.x, point.y, n, rectangle);
    }

    void PuzzleCoords2Canvas(int n, int n2, int n3, Rectangle rectangle) {
        Dimension dimension = this.size();
        int n4 = (dimension.width - 2 * this.ivBorderH - n3 * this.ivSolver.ivOplossingBreedte - this.ivLineThickness) / 2;
        int n5 = (dimension.height - 2 * this.ivBorderV - n3 * this.ivSolver.ivOplossingHoogte - this.ivLineThickness) / 2;
        rectangle.x = n4 + (n - 1) * n3 + this.ivBorderH;
        rectangle.y = n5 + (this.ivSolver.ivOplossingHoogte - n2) * n3 + this.ivBorderV;
        rectangle.width = n3;
        rectangle.height = n3;
    }

    int CalcUnitSize() {
        int n;
        Dimension dimension = this.size();
        int n2 = (dimension.width - this.ivLineThickness - 2 * this.ivBorderH) / this.ivSolver.ivOplossingBreedte;
        int n3 = (dimension.height - this.ivLineThickness - 2 * this.ivBorderV) / this.ivSolver.ivOplossingHoogte;
        int n4 = n = n2 < n3 ? n2 : n3;
        if (n < 2 * this.ivLineThickness) {
            n = 2 * this.ivLineThickness;
        }
        return n;
    }

    synchronized void SetSolution(PieceInPuzzle[] pieceInPuzzleArray, int n) {
        this.ivSolution = pieceInPuzzleArray;
        this.ivSolutionNo = this.ivSolution == null ? 0 : n;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }
}

