/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Point;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;

final class Solver
extends Observable {
    static final int cStatusNotReady = 0;
    static final int cStatusReadyToRun = 1;
    static final int cStatusRunning = 2;
    static final int cStatusCompleted = 3;
    static final int cStatusAborted = 4;
    static final int cStatusInitError = 5;
    static final int cStatusAbortedWithError = 6;
    static final int[] cSignatuurOrde1;
    static final int[] cSignatuurOrde2;
    static final int[] cSignatuurOrde3;
    static final int[] cSignatuurOrde4;
    static final int[] cSignatuurOrde5;
    Vector ivStukVerzameling;
    int[] ivStukAantal;
    int[] ivStukIndex;
    OplosCelType[] ivOplossing;
    OplosCelType[] ivHulpOplossing;
    int ivOplossingHoogte;
    int ivOplossingBreedte;
    int ivTotaleHoogte;
    int ivRand;
    int ivAllocRand;
    int ivAantalStukken;
    int ivCheckIsoFreq;
    boolean ivLVPInKleinste = false;
    int ivCheckIsoTeller;
    int ivIsoKVP;
    int ivRefKleur;
    Vector[] ivVrijheden;
    int[][] ivVrijhedenIndex;
    int[] ivSignatuurOrde;
    int ivLaagsteSignatuurWaarde;
    int ivAantalOplossingen;
    int ivMinOpp = Integer.MAX_VALUE;
    int ivMaxOpp;
    boolean ivStopSolving = false;
    int ivNumPiecesInPuzzle;
    PieceInPuzzle[] ivPiecesInPuzzle;
    boolean ivNotifyPerPiece = false;
    boolean ivMustReportPieces = false;
    LVPInfo[] ivLVPStack;
    int ivLVPStackPointer;
    Vector ivSolutions;
    Vector ivSolutionChecksum;
    int ivStatus = 0;
    int ivOplSym = -1;
    Object ivTotaalGeplaatstSync;
    long ivTotaalGeplaatst;
    Clock ivClock;
    Applet ivApplet;

    public Solver(Polyomino polyomino) {
        this(polyomino, false, false);
    }

    public Solver(Polyomino polyomino, boolean bl, boolean bl2) {
        this.ivApplet = polyomino;
        this.ivTotaalGeplaatstSync = new Object();
        this.ivMustReportPieces = bl2;
        this.ivNotifyPerPiece = bl;
        String string = polyomino.getParameter("CheckIsoFreq");
        if (string != null) {
            this.ivCheckIsoFreq = Integer.parseInt(string);
        }
        if ((string = polyomino.getParameter("AFPInSmallest")) != null) {
            this.ivLVPInKleinste = new Boolean(string);
            if (this.ivLVPInKleinste) {
                this.ivCheckIsoFreq = 1;
            }
        }
        if (this.InitPuzzle(polyomino) == 0 || this.InitPieces(polyomino) == 0 || this.InitVrijheden() == 0) {
            this.SetStatus(5);
            return;
        }
        this.ivSolutions = new Vector(100, 100);
        this.ivSolutionChecksum = new Vector(100, 100);
        this.ivClock = new Clock();
        this.ivSignatuurOrde = cSignatuurOrde5;
        this.ivLaagsteSignatuurWaarde = Integer.MAX_VALUE;
        int n = 0;
        while (n < this.ivSignatuurOrde.length) {
            if (this.ivSignatuurOrde[n] < this.ivLaagsteSignatuurWaarde) {
                this.ivLaagsteSignatuurWaarde = this.ivSignatuurOrde[n];
            }
            ++n;
        }
        this.SetStatus(1);
    }

    synchronized void SetStatus(int n) {
        this.ivStatus = n;
        this.setChanged();
        this.notifyObservers(new SolverEvent(1, this.ivStatus));
    }

    synchronized int GetStatus() {
        return this.ivStatus;
    }

    public void Solve() {
        if (this.GetStatus() == 1) {
            this.SetStatus(2);
            try {
                this.ivClock.Start();
                this.ZoekOplossingen((1 + this.ivRand - 1) * this.ivTotaleHoogte + (1 + this.ivRand - 1));
                this.ivClock.Stop();
            }
            catch (Error error) {
                this.ivClock.Stop();
                this.SetStatus(6);
                throw error;
            }
            catch (RuntimeException runtimeException) {
                this.ivClock.Stop();
                this.SetStatus(6);
                throw runtimeException;
            }
            catch (Throwable throwable) {
                this.ivClock.Stop();
                this.SetStatus(6);
            }
            if (this.ivStopSolving) {
                this.SetStatus(4);
                return;
            }
            this.SetStatus(3);
        }
    }

    int GetTimeElapsed() {
        return this.ivClock.GetClockTime();
    }

    private boolean ZoekOplossingen(int n) {
        if (this.ivCheckIsoFreq > 0) {
            ++this.ivCheckIsoTeller;
            if (this.ivCheckIsoTeller >= this.ivCheckIsoFreq) {
                this.ivCheckIsoTeller = 0;
                if (this.CheckIsolaties(n, true)) {
                    this.ivIsoKVP = 0;
                    return true;
                }
            }
        } else {
            this.ivIsoKVP = 0;
        }
        LVPInfo lVPInfo = this.ivLVPStack[this.ivLVPStackPointer];
        lVPInfo.kleinsteIndex = n;
        if (!this.BepaalLVP(lVPInfo)) {
            this.AddSolution();
        } else {
            int n2 = 0;
            while (n2 < this.ivAantalStukken) {
                if (this.ivStukAantal[n2] > 0) {
                    int n3 = this.ivVrijhedenIndex[lVPInfo.signatuur][n2];
                    int n4 = this.ivVrijhedenIndex[lVPInfo.signatuur][n2 + 1];
                    int n5 = n3;
                    while (n5 < n4) {
                        block13: {
                            StukHokType stukHokType = (StukHokType)this.ivVrijheden[lVPInfo.signatuur].elementAt(n5);
                            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(stukHokType.stukNr);
                            int n6 = lVPInfo.LVP - stukType.coord[stukHokType.hokNr];
                            int n7 = 0;
                            while (n7 < stukType.oppervlakte) {
                                if (this.ivOplossing[stukType.coord[n7] + n6].bezet == 0) {
                                    ++n7;
                                    continue;
                                }
                                break block13;
                            }
                            int n8 = n2;
                            int n9 = this.ivStukAantal[n8];
                            this.ivStukAantal[n8] = n9 - 1;
                            this.Plaats(stukHokType, lVPInfo.LVP, n2, 1, n9);
                            ++this.ivLVPStackPointer;
                            boolean bl = this.ZoekOplossingen(lVPInfo.kleinsteIndex);
                            --this.ivLVPStackPointer;
                            int n10 = n2;
                            int n11 = this.ivStukAantal[n10] + 1;
                            this.ivStukAantal[n10] = n11;
                            this.Plaats(stukHokType, lVPInfo.LVP, -n2, -1, n11);
                            if (this.ivStopSolving) {
                                return false;
                            }
                            if (bl && this.ivCheckIsoFreq > 1 && this.CheckIsolaties(n, false)) {
                                return true;
                            }
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private int FindKVP(int n) {
        int n2 = this.ivOplossingBreedte;
        int n3 = this.ivOplossingHoogte;
        n2 = (n2 + this.ivRand - 1) * this.ivTotaleHoogte + (n3 + this.ivRand - 1) + 1;
        while (n < n2) {
            if (this.ivHulpOplossing[n] != null && this.ivHulpOplossing[n].bezet == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int TelOpp(OplosCelType[] oplosCelTypeArray, int n, int n2) {
        oplosCelTypeArray[n].bezet = n2;
        return 1 + this.TelOppBoven(oplosCelTypeArray, n, n2) + this.TelOppRechts(oplosCelTypeArray, n, n2) + this.TelOppOnder(oplosCelTypeArray, n, n2) + this.TelOppLinks(oplosCelTypeArray, n, n2);
    }

    private int TelOppBoven(OplosCelType[] oplosCelTypeArray, int n, int n2) {
        if (oplosCelTypeArray[++n].bezet == 0) {
            oplosCelTypeArray[n].bezet = n2;
            return 1 + this.TelOppBoven(oplosCelTypeArray, n, n2) + this.TelOppLinks(oplosCelTypeArray, n, n2) + this.TelOppRechts(oplosCelTypeArray, n, n2);
        }
        return 0;
    }

    private int TelOppOnder(OplosCelType[] oplosCelTypeArray, int n, int n2) {
        if (oplosCelTypeArray[--n].bezet == 0) {
            oplosCelTypeArray[n].bezet = n2;
            return 1 + this.TelOppOnder(oplosCelTypeArray, n, n2) + this.TelOppLinks(oplosCelTypeArray, n, n2) + this.TelOppRechts(oplosCelTypeArray, n, n2);
        }
        return 0;
    }

    private int TelOppRechts(OplosCelType[] oplosCelTypeArray, int n, int n2) {
        if (oplosCelTypeArray[n += this.ivTotaleHoogte].bezet == 0) {
            oplosCelTypeArray[n].bezet = n2;
            return 1 + this.TelOppOnder(oplosCelTypeArray, n, n2) + this.TelOppBoven(oplosCelTypeArray, n, n2) + this.TelOppRechts(oplosCelTypeArray, n, n2);
        }
        return 0;
    }

    private int TelOppLinks(OplosCelType[] oplosCelTypeArray, int n, int n2) {
        if (oplosCelTypeArray[n -= this.ivTotaleHoogte].bezet == 0) {
            oplosCelTypeArray[n].bezet = n2;
            return 1 + this.TelOppOnder(oplosCelTypeArray, n, n2) + this.TelOppBoven(oplosCelTypeArray, n, n2) + this.TelOppLinks(oplosCelTypeArray, n, n2);
        }
        return 0;
    }

    private boolean CheckIsolaties(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = -10;
        int n3 = Integer.MAX_VALUE;
        this.CopyOplossingToHulp();
        n = this.FindKVP(n);
        while (n != -1 && !bl2) {
            int n4 = this.TelOpp(this.ivHulpOplossing, n, n2);
            if (this.ivMinOpp == this.ivMaxOpp) {
                bl2 = n4 % this.ivMinOpp != 0;
            } else {
                boolean bl3 = bl2 = n4 < this.ivMinOpp;
            }
            if (bl) {
                if (bl2) {
                    this.ivIsoKVP = n;
                } else if (n4 < n3) {
                    n3 = n4;
                    this.ivIsoKVP = n;
                }
            }
            if (bl2) continue;
            --n2;
            n = this.FindKVP(n);
        }
        return bl2;
    }

    private void CopyOplossingToHulp() {
        int n = 0;
        while (n < this.ivOplossing.length) {
            OplosCelType oplosCelType = this.ivOplossing[n];
            if (oplosCelType != null) {
                OplosCelType oplosCelType2 = this.ivHulpOplossing[n];
                oplosCelType2.bezet = oplosCelType.bezet;
                oplosCelType2.vrijheidsSignatuur = oplosCelType.vrijheidsSignatuur;
            }
            ++n;
        }
    }

    private boolean BepaalLVP(LVPInfo lVPInfo) {
        if (this.ivLVPInKleinste) {
            if (this.ivIsoKVP == 0) {
                this.CheckIsolaties(lVPInfo.kleinsteIndex, true);
            }
            this.ivRefKleur = this.ivHulpOplossing[this.ivIsoKVP].bezet;
        }
        boolean bl = true;
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = lVPInfo.kleinsteIndex / this.ivTotaleHoogte + 1 - this.ivRand;
        int n5 = lVPInfo.kleinsteIndex;
        int n6 = n5 / this.ivTotaleHoogte * this.ivTotaleHoogte + this.ivRand;
        int n7 = n4;
        block0: while (n7 <= this.ivOplossingBreedte) {
            int n8 = n5;
            while (n8 < n6 + this.ivOplossingHoogte) {
                OplosCelType oplosCelType = this.ivOplossing[n8];
                if (oplosCelType.bezet == 0) {
                    if (bl) {
                        bl = false;
                        n4 = n7;
                        lVPInfo.kleinsteIndex = n8;
                    }
                    if ((this.ivRefKleur == 0 || this.ivHulpOplossing[n8].bezet == this.ivRefKleur) && this.ivSignatuurOrde[oplosCelType.vrijheidsSignatuur] < n2) {
                        n2 = this.ivSignatuurOrde[oplosCelType.vrijheidsSignatuur];
                        n3 = oplosCelType.vrijheidsSignatuur;
                        n = n8;
                        if (n2 == this.ivLaagsteSignatuurWaarde) break block0;
                    }
                }
                ++n8;
            }
            n5 = n6 += this.ivTotaleHoogte;
            ++n7;
        }
        lVPInfo.LVP = n;
        lVPInfo.signatuur = n3;
        return n != 0;
    }

    private synchronized void Plaats(StukHokType stukHokType, int n, int n2, int n3, int n4) {
        StukType stukType = (StukType)this.ivStukVerzameling.elementAt(stukHokType.stukNr);
        int n5 = n - stukType.coord[stukHokType.hokNr];
        int n6 = 0;
        while (n6 < stukType.oppervlakte) {
            int n7 = stukType.coord[n6] + n5;
            this.ivOplossing[n7].bezet += n2 + n3;
            this.ivOplossing[n7 - this.ivTotaleHoogte].vrijheidsSignatuur ^= 2;
            this.ivOplossing[n7 + this.ivTotaleHoogte].vrijheidsSignatuur ^= 8;
            this.ivOplossing[n7 - 1].vrijheidsSignatuur ^= 1;
            this.ivOplossing[n7 + 1].vrijheidsSignatuur ^= 4;
            ++n6;
        }
        if (n3 > 0) {
            this.IncrementTotaalGeplaatst();
        }
        if (this.ivPiecesInPuzzle != null) {
            if (n3 > 0) {
                PieceInPuzzle pieceInPuzzle = this.ivPiecesInPuzzle[this.ivNumPiecesInPuzzle];
                pieceInPuzzle.instance = n4;
                pieceInPuzzle.hetStukType = stukType;
                int n8 = n5 + stukType.coord[stukType.mainCoord];
                pieceInPuzzle.x = n8 / this.ivTotaleHoogte + 1 - this.ivRand;
                pieceInPuzzle.y = n8 % this.ivTotaleHoogte + 1 - this.ivRand;
                ++this.ivNumPiecesInPuzzle;
                return;
            }
            --this.ivNumPiecesInPuzzle;
        }
    }

    synchronized PieceInPuzzle[] CopyCurrentPiecesInPuzzle() {
        PieceInPuzzle[] pieceInPuzzleArray = new PieceInPuzzle[this.ivNumPiecesInPuzzle];
        try {
            int n = 0;
            while (n < pieceInPuzzleArray.length) {
                pieceInPuzzleArray[n] = (PieceInPuzzle)this.ivPiecesInPuzzle[n].clone();
                ++n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
        return pieceInPuzzleArray;
    }

    void IndexToXY(int n, Point point) {
        point.x = n / this.ivTotaleHoogte + 1 - this.ivRand;
        point.y = n % this.ivTotaleHoogte + 1 - this.ivRand;
    }

    int XYToIndex(int n, int n2) {
        return (n + this.ivRand - 1) * this.ivTotaleHoogte + (n2 + this.ivRand - 1);
    }

    int GeefVeldBezet(int n, int n2) {
        OplosCelType oplosCelType = this.ivOplossing[(n + this.ivRand - 1) * this.ivTotaleHoogte + (n2 + this.ivRand - 1)];
        if (oplosCelType == null) {
            return 0;
        }
        return oplosCelType.bezet;
    }

    boolean IsPuzzleVeld(int n, int n2) {
        OplosCelType oplosCelType = this.ivOplossing[(n + this.ivRand - 1) * this.ivTotaleHoogte + (n2 + this.ivRand - 1)];
        if (oplosCelType == null) {
            return false;
        }
        return oplosCelType.bezet != -1 && oplosCelType.bezet != -2;
    }

    void VulVrijheidsWaardes() {
        int n = 0;
        while (n < this.ivOplossing.length) {
            OplosCelType oplosCelType = this.ivOplossing[n];
            if (oplosCelType != null) {
                oplosCelType.vrijheidsSignatuur = 15;
            }
            ++n;
        }
        int n2 = 1;
        while (n2 <= this.ivOplossingBreedte) {
            int n3 = 1;
            while (n3 <= this.ivOplossingHoogte) {
                if (this.IsPuzzleVeld(n2, n3)) {
                    int n4 = (n2 + this.ivRand - 1) * this.ivTotaleHoogte + (n3 + this.ivRand - 1);
                    if (this.IsPuzzleVeld(n2 - 1, n3)) {
                        this.ivOplossing[n4].vrijheidsSignatuur ^= 8;
                    }
                    if (this.IsPuzzleVeld(n2, n3 - 1)) {
                        this.ivOplossing[n4].vrijheidsSignatuur ^= 4;
                    }
                    if (this.IsPuzzleVeld(n2 + 1, n3)) {
                        this.ivOplossing[n4].vrijheidsSignatuur ^= 2;
                    }
                    if (this.IsPuzzleVeld(n2, n3 + 1)) {
                        this.ivOplossing[n4].vrijheidsSignatuur ^= 1;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    int InitPuzzle(Polyomino polyomino) {
        this.ivRefKleur = 0;
        this.ivIsoKVP = 0;
        this.ivCheckIsoTeller = 0;
        this.ivStopSolving = false;
        int n = 0;
        String string = polyomino.getParameter("NumPieces");
        if (string == null) {
            MessageBox.DoErrorMessage("Polyomino", "Required parameter NumPieces is missing", this.ivApplet);
            return 0;
        }
        this.ivAantalStukken = Integer.parseInt(string);
        int n2 = 0;
        while (n2 < this.ivAantalStukken) {
            int n3 = this.GeefStukOppervlak(polyomino, n2 + 1);
            if (n3 < 0) {
                return 0;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        string = polyomino.getParameter("PuzzleHeight");
        if (string == null) {
            MessageBox.DoErrorMessage("Polyomino", "Required parameter PuzzleHeight is missing", this.ivApplet);
            return 0;
        }
        this.ivOplossingHoogte = Integer.parseInt(string);
        string = polyomino.getParameter("PuzzleWidth");
        if (string == null) {
            MessageBox.DoErrorMessage("Polyomino", "Required parameter PuzzleWidth is missing", this.ivApplet);
            return 0;
        }
        this.ivOplossingBreedte = Integer.parseInt(string);
        this.ivRand = n;
        this.ivRand = this.ivOplossingBreedte > this.ivOplossingHoogte ? (this.ivRand += this.ivOplossingBreedte) : (this.ivRand += this.ivOplossingHoogte);
        this.ivTotaleHoogte = this.ivOplossingHoogte + 2 * this.ivRand;
        int n4 = this.ivTotaleHoogte * (this.ivOplossingBreedte + 2 * this.ivRand);
        this.ivAllocRand = n - 1;
        if (this.ivAllocRand <= 0) {
            this.ivAllocRand = 1;
        }
        this.ivOplossing = new OplosCelType[n4];
        this.ivHulpOplossing = new OplosCelType[n4];
        Point point = new Point(0, 0);
        n2 = 0;
        while (n2 < n4) {
            this.IndexToXY(n2, point);
            if (point.x >= 1 - this.ivAllocRand && point.x <= this.ivOplossingBreedte + this.ivAllocRand && point.y >= 1 - this.ivAllocRand && point.y <= this.ivOplossingHoogte + this.ivAllocRand) {
                this.ivOplossing[n2] = new OplosCelType();
                this.ivHulpOplossing[n2] = new OplosCelType();
                this.ivOplossing[n2].bezet = -1;
            } else {
                this.ivOplossing[n2] = null;
                this.ivHulpOplossing[n2] = null;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.ivOplossingHoogte) {
            int n5 = 1;
            while (n5 <= this.ivOplossingBreedte) {
                this.ivOplossing[(n5 + this.ivRand - 1) * this.ivTotaleHoogte + (n2 + this.ivRand - 1)].bezet = 0;
                ++n5;
            }
            ++n2;
        }
        string = polyomino.getParameter("Holes");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n6 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    MessageBox.DoErrorMessage("Polyomino", "Odd number of values in coordinate list (parameter Holes)", this.ivApplet);
                    return 0;
                }
                int n7 = Integer.parseInt(stringTokenizer.nextToken());
                if (n6 < 1 || n6 > this.ivOplossingBreedte || n7 < 1 || n7 > this.ivOplossingHoogte) continue;
                this.ivOplossing[(n6 + this.ivRand - 1) * this.ivTotaleHoogte + (n7 + this.ivRand - 1)].bezet = -2;
            }
        }
        this.VulVrijheidsWaardes();
        return 1;
    }

    int GeefStukOppervlak(Polyomino polyomino, int n) {
        String string = polyomino.getParameter("Piece" + n);
        if (string == null) {
            MessageBox.DoErrorMessage("Polyomino", "Parameter Piece" + n + " not found", this.ivApplet);
            return -1;
        }
        int n2 = StukType.GeefOppervlakteFromParm(polyomino.ivVersion, string);
        if (n2 == -1) {
            MessageBox.DoErrorMessage("Polyomino", "Parameter Piece" + n + " invalid format", this.ivApplet);
        }
        return n2;
    }

    int LegPositieVastVersie1(Polyomino polyomino, int n, int n2, String string) {
        StukType stukType = new StukType(1, string, n2, n + 1, this);
        if (stukType.stukNr == 0) {
            MessageBox.DoErrorMessage("Polyomino", "Could not create Piece" + n, this.ivApplet);
            return 0;
        }
        if (stukType.oppervlakte < this.ivMinOpp) {
            this.ivMinOpp = stukType.oppervlakte;
        }
        if (stukType.oppervlakte > this.ivMaxOpp) {
            this.ivMaxOpp = stukType.oppervlakte;
        }
        if (this.ivStukVerzameling.indexOf(stukType, this.ivStukIndex[n]) == -1) {
            int n3 = StukType.GeefMaxRPFromParm(polyomino.ivVersion, string);
            if (n3 == -1) {
                MessageBox.DoErrorMessage("Polyomino", "Could not create Piece" + n, this.ivApplet);
                return 0;
            }
            if (this.ivStukVerzameling.size() - this.ivStukIndex[n] < n3) {
                this.ivStukVerzameling.addElement(stukType);
            }
        }
        return 1;
    }

    int LegPositieVastVersie2(Polyomino polyomino, int n, int n2, String string) {
        if (n2 > 4 && !StukType.GeefCanFlipFromParm(2, string)) {
            return 1;
        }
        StukType stukType = new StukType(2, string, n2, n + 1, this);
        if (stukType.stukNr == 0) {
            MessageBox.DoErrorMessage("Polyomino", "Could not create Piece" + n, this.ivApplet);
            return 0;
        }
        if (stukType.oppervlakte < this.ivMinOpp) {
            this.ivMinOpp = stukType.oppervlakte;
        }
        if (stukType.oppervlakte > this.ivMaxOpp) {
            this.ivMaxOpp = stukType.oppervlakte;
        }
        if (this.ivStukVerzameling.indexOf(stukType, this.ivStukIndex[n]) == -1) {
            this.ivStukVerzameling.addElement(stukType);
        }
        return 1;
    }

    int LegPositieVast(Polyomino polyomino, int n, int n2, String string) {
        switch (polyomino.ivVersion) {
            case 1: {
                return this.LegPositieVastVersie1(polyomino, n, n2, string);
            }
            case 2: {
                return this.LegPositieVastVersie2(polyomino, n, n2, string);
            }
        }
        MessageBox.DoErrorMessage("Polyomino", "Unknown version number", this.ivApplet);
        return 0;
    }

    boolean CheckOppervlakte() {
        int n;
        int n2 = 0;
        int n3 = 1;
        while (n3 <= this.ivOplossingBreedte) {
            n = 1;
            while (n <= this.ivOplossingHoogte) {
                if (this.IsPuzzleVeld(n3, n)) {
                    ++n2;
                }
                ++n;
            }
            ++n3;
        }
        n = 0;
        int n4 = 0;
        while (n4 < this.ivAantalStukken) {
            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(this.ivStukIndex[n4]);
            n += this.ivStukAantal[n4] * stukType.oppervlakte;
            ++n4;
        }
        if (n2 > n) {
            MessageBox.DoWarningMessage("Polyomino", "Total area covered by the pieces is " + n + ".\n" + "The area of the solution is " + n2 + ", so there are no solutions.", this.ivApplet);
            return false;
        }
        if (n2 < n) {
            MessageBox.DoInfoMessage("Polyomino", "The area covered by all pieces is greater than the\narea of the solution. As a result not all pieces can\nbe used at the same time in any solution.", this.ivApplet);
            return true;
        }
        return true;
    }

    void CheckSamenhang() {
        boolean bl = false;
        String string = new String("These pieces consist of two or more separate parts: ");
        int n = 0;
        while (n < this.ivStukVerzameling.size()) {
            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(n);
            if (stukType.rp == 1 && !stukType.IsSamenHangend(this)) {
                string = String.valueOf(string) + stukType.stukNr + " ";
                bl = true;
            }
            ++n;
        }
        if (bl) {
            MessageBox.DoWarningMessage("Polyomino", string, this.ivApplet);
        }
    }

    int InitPieces(Polyomino polyomino) {
        int n;
        this.ivMinOpp = Integer.MAX_VALUE;
        this.ivMaxOpp = Integer.MIN_VALUE;
        this.ivStukVerzameling = new Vector(100, 100);
        this.ivStukAantal = new int[this.ivAantalStukken + 1];
        this.ivStukIndex = new int[this.ivAantalStukken + 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.ivAantalStukken) {
            String string = polyomino.getParameter("Piece" + (n3 + 1));
            if (string == null) {
                MessageBox.DoErrorMessage("Polyomino", "Parameter Piece" + n3 + " not found", this.ivApplet);
                return 0;
            }
            n = StukType.GeefExemplarenFromParm(polyomino.ivVersion, string);
            n2 += n;
            this.ivStukAantal[n3] = n;
            this.ivStukIndex[n3] = this.ivStukVerzameling.size();
            int n4 = 1;
            while (n4 <= 8) {
                if (this.LegPositieVast(polyomino, n3, n4, string) == 0) {
                    return 0;
                }
                ++n4;
            }
            ++n3;
        }
        this.ivStukIndex[this.ivAantalStukken] = this.ivStukVerzameling.size();
        int n5 = this.BepaalSymmetrieStuk();
        if (n5 == 0) {
            n5 = 1;
        }
        if (this.ivStukAantal[n5 - 1] > 1) {
            this.SplitsStuk(n5);
        }
        this.BeperkSymmRP(n5);
        this.ivStukVerzameling.trimToSize();
        this.CheckSamenhang();
        if (!this.CheckOppervlakte()) {
            return 0;
        }
        if (this.ivMustReportPieces) {
            this.ivPiecesInPuzzle = new PieceInPuzzle[n2];
            n = 0;
            while (n < n2) {
                this.ivPiecesInPuzzle[n] = new PieceInPuzzle();
                ++n;
            }
            this.ivNumPiecesInPuzzle = 0;
        }
        this.ivLVPStack = new LVPInfo[n2 + 1];
        n = 0;
        while (n < n2 + 1) {
            this.ivLVPStack[n] = new LVPInfo();
            ++n;
        }
        this.ivLVPStackPointer = 0;
        return 1;
    }

    void SplitsStuk(int n) {
        int n2 = this.ivStukIndex[n - 1];
        while (n2 < this.ivStukIndex[n]) {
            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(n2);
            try {
                this.ivStukVerzameling.addElement(stukType.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.getMessage());
            }
            ++n2;
        }
        this.ivStukIndex[this.ivAantalStukken + 1] = this.ivStukVerzameling.size();
        this.ivStukAantal[this.ivAantalStukken] = this.ivStukAantal[n - 1] - 1;
        this.ivStukAantal[n - 1] = 1;
        ++this.ivAantalStukken;
    }

    int BepaalSymmetrieStuk() {
        if (this.ivOplSym < 0) {
            StukType stukType = new StukType(this);
            this.ivOplSym = stukType.BepaalSymmetrie(this);
        }
        int n = 0;
        while (n < this.ivAantalStukken) {
            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(this.ivStukIndex[n]);
            int n2 = stukType.BepaalSymmetrie(this);
            if ((this.ivOplSym & n2) == 0) {
                return n + 1;
            }
            ++n;
        }
        return 0;
    }

    void BeperkSymmRP(int n) {
        Cloneable cloneable;
        if (this.ivOplSym < 0) {
            cloneable = new StukType(this);
            this.ivOplSym = ((StukType)cloneable).BepaalSymmetrie(this);
        }
        if (this.ivOplSym == 0) {
            return;
        }
        cloneable = new BitSet(9);
        ((BitSet)cloneable).set(7);
        ((BitSet)cloneable).set(8);
        if ((this.ivOplSym & 1) == 1) {
            ((BitSet)cloneable).set(5);
            ((BitSet)cloneable).set(6);
        }
        if ((this.ivOplSym & 2) == 2) {
            ((BitSet)cloneable).set(3);
            ((BitSet)cloneable).set(4);
        }
        if ((this.ivOplSym & 6) == 6) {
            ((BitSet)cloneable).set(2);
            ((BitSet)cloneable).set(6);
        }
        int n2 = 1;
        while (n2 <= 8) {
            if (((BitSet)cloneable).get(n2)) {
                this.VerwijderRPUitStukverzameling(n, n2);
            }
            ++n2;
        }
    }

    void VerwijderRPUitStukverzameling(int n, int n2) {
        int n3 = this.ivStukIndex[n - 1];
        while (n3 < this.ivStukIndex[n]) {
            StukType stukType = (StukType)this.ivStukVerzameling.elementAt(n3);
            if (stukType.rp == n2) {
                this.ivStukVerzameling.removeElementAt(n3);
                int n4 = n;
                while (n4 <= this.ivAantalStukken) {
                    int n5 = n4++;
                    this.ivStukIndex[n5] = this.ivStukIndex[n5] - 1;
                }
                return;
            }
            ++n3;
        }
    }

    int BehandelVrijheid(int n, StukType stukType, int n2, int n3) {
        boolean bl = true;
        if ((n & 8) != 0) {
            boolean bl2 = bl = !stukType.heeftcoord(stukType.coord[n3] - this.ivTotaleHoogte);
        }
        if (bl && (n & 4) != 0) {
            boolean bl3 = bl = !stukType.heeftcoord(stukType.coord[n3] - 1);
        }
        if (bl && (n & 2) != 0) {
            boolean bl4 = bl = !stukType.heeftcoord(stukType.coord[n3] + this.ivTotaleHoogte);
        }
        if (bl && (n & 1) != 0) {
            boolean bl5 = bl = !stukType.heeftcoord(stukType.coord[n3] + 1);
        }
        if (bl) {
            this.ivVrijheden[n].addElement(new StukHokType(n2, n3));
        }
        return 1;
    }

    int InitVrijheden() {
        int n;
        this.ivVrijheden = new Vector[16];
        this.ivVrijhedenIndex = new int[16][];
        int n2 = 0;
        while (n2 < 16) {
            this.ivVrijheden[n2] = null;
            this.ivVrijhedenIndex[n2] = null;
            ++n2;
        }
        this.ivVrijhedenIndex[5] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[7] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[10] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[11] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[12] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[13] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[14] = new int[this.ivAantalStukken + 1];
        this.ivVrijhedenIndex[15] = new int[this.ivAantalStukken + 1];
        this.ivVrijheden[5] = new Vector(100, 100);
        this.ivVrijheden[7] = new Vector(100, 100);
        this.ivVrijheden[10] = new Vector(100, 100);
        this.ivVrijheden[11] = new Vector(100, 100);
        this.ivVrijheden[12] = new Vector(100, 100);
        this.ivVrijheden[13] = new Vector(100, 100);
        this.ivVrijheden[14] = new Vector(100, 100);
        this.ivVrijheden[15] = new Vector(100, 100);
        int n3 = 0;
        while (n3 < this.ivAantalStukken) {
            n = 0;
            while (n < 16) {
                if (this.ivVrijheden[n] != null) {
                    this.ivVrijhedenIndex[n][n3] = this.ivVrijheden[n].size();
                }
                ++n;
            }
            int n4 = this.ivStukIndex[n3];
            while (n4 < this.ivStukIndex[n3 + 1]) {
                StukType stukType = (StukType)this.ivStukVerzameling.elementAt(n4);
                int n5 = stukType.oppervlakte;
                int n6 = 0;
                while (n6 < n5) {
                    n = 0;
                    while (n < 16) {
                        if (this.ivVrijheden[n] != null && this.BehandelVrijheid(n, stukType, n4, n6) == 0) {
                            return 0;
                        }
                        ++n;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n3;
        }
        n = 0;
        while (n < 16) {
            if (this.ivVrijheden[n] != null) {
                this.ivVrijheden[n].trimToSize();
                this.ivVrijhedenIndex[n][this.ivAantalStukken] = this.ivVrijheden[n].size();
            }
            ++n;
        }
        return 1;
    }

    void SolutionFound() {
        this.AddSolution();
    }

    synchronized boolean AddSolution() {
        PieceInPuzzle[] pieceInPuzzleArray = new PieceInPuzzle[this.ivNumPiecesInPuzzle];
        int n = 0;
        while (n < this.ivNumPiecesInPuzzle) {
            try {
                pieceInPuzzleArray[n] = (PieceInPuzzle)this.ivPiecesInPuzzle[n].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.getMessage());
            }
            ++n;
        }
        SolutionSignature solutionSignature = new SolutionSignature(this, pieceInPuzzleArray);
        if (this.ivSolutionChecksum.indexOf(solutionSignature) == -1) {
            this.ivSolutions.addElement(pieceInPuzzleArray);
            this.ivSolutionChecksum.addElement(solutionSignature);
            this.setChanged();
            this.notifyObservers(new SolverEvent(2, this.GetNumSolutions()));
            return true;
        }
        return false;
    }

    synchronized int GetHighSolutionIndex() {
        int n = -1;
        if (this.ivSolutions != null) {
            n = this.ivSolutions.size() - 1;
        }
        return n;
    }

    synchronized int GetNumSolutions() {
        return this.GetHighSolutionIndex() + 1;
    }

    int GeefRandVrijheid(int n, int n2) {
        int n3 = 0;
        int n4 = (n + this.ivRand - 1) * this.ivTotaleHoogte + (n2 + this.ivRand - 1);
        if (this.ivOplossing[n4].bezet == -2 || this.ivOplossing[n4].bezet == -1) {
            return -1;
        }
        if (this.ivOplossing[n4 - this.ivTotaleHoogte].bezet == -1 || this.ivOplossing[n4 - this.ivTotaleHoogte].bezet == -2) {
            n3 |= 8;
        }
        if (this.ivOplossing[n4 - 1].bezet == -1 || this.ivOplossing[n4 - 1].bezet == -2) {
            n3 |= 4;
        }
        if (this.ivOplossing[n4 + this.ivTotaleHoogte].bezet == -1 || this.ivOplossing[n4 + this.ivTotaleHoogte].bezet == -2) {
            n3 |= 2;
        }
        if (this.ivOplossing[n4 + 1].bezet == -1 || this.ivOplossing[n4 + 1].bezet == -2) {
            n3 |= 1;
        }
        return n3;
    }

    long GetTotaalGeplaatst() {
        Object object = this.ivTotaalGeplaatstSync;
        synchronized (object) {
            long l = this.ivTotaalGeplaatst;
            Object var4_3 = null;
            return l;
        }
    }

    void IncrementTotaalGeplaatst() {
        Object object = this.ivTotaalGeplaatstSync;
        synchronized (object) {
            ++this.ivTotaalGeplaatst;
            return;
        }
    }

    void SchrijfOplossing(PrintStream printStream) {
        printStream.println("Oplossing nr. " + this.ivSolutions.size());
        int n = this.ivOplossingHoogte;
        while (n >= 1) {
            int n2 = 1;
            while (n2 <= this.ivOplossingBreedte) {
                int n3 = this.ivOplossing[(n2 + this.ivRand - 1) * this.ivTotaleHoogte + (n + this.ivRand - 1)].bezet;
                if (n3 == -2) {
                    printStream.print("   ");
                } else {
                    printStream.print(" ");
                    if (n3 < 10 && n3 >= 0) {
                        printStream.print(" ");
                    }
                    printStream.print(n3);
                }
                ++n2;
            }
            printStream.println();
            --n;
        }
        printStream.println();
        printStream.flush();
    }

    static {
        int[] nArray = new int[16];
        nArray[0] = 15;
        nArray[1] = 14;
        nArray[2] = 13;
        nArray[3] = 9;
        nArray[4] = 12;
        nArray[5] = 6;
        nArray[6] = 8;
        nArray[7] = 4;
        nArray[8] = 11;
        nArray[9] = 10;
        nArray[10] = 5;
        nArray[11] = 3;
        nArray[12] = 7;
        nArray[13] = 2;
        nArray[14] = 1;
        cSignatuurOrde1 = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 15;
        nArray2[1] = 14;
        nArray2[2] = 13;
        nArray2[3] = 9;
        nArray2[4] = 12;
        nArray2[5] = 5;
        nArray2[6] = 8;
        nArray2[7] = 3;
        nArray2[8] = 11;
        nArray2[9] = 10;
        nArray2[10] = 6;
        nArray2[11] = 4;
        nArray2[12] = 7;
        nArray2[13] = 1;
        nArray2[14] = 2;
        cSignatuurOrde2 = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = 5;
        nArray3[1] = 4;
        nArray3[2] = 4;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 2;
        nArray3[6] = 3;
        nArray3[7] = 1;
        nArray3[8] = 4;
        nArray3[9] = 3;
        nArray3[10] = 2;
        nArray3[11] = 1;
        nArray3[12] = 3;
        nArray3[13] = 1;
        nArray3[14] = 1;
        cSignatuurOrde3 = nArray3;
        int[] nArray4 = new int[16];
        nArray4[0] = 5;
        nArray4[1] = 4;
        nArray4[2] = 4;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 1;
        nArray4[6] = 3;
        nArray4[7] = 2;
        nArray4[8] = 4;
        nArray4[9] = 3;
        nArray4[10] = 1;
        nArray4[11] = 2;
        nArray4[12] = 3;
        nArray4[13] = 2;
        nArray4[14] = 2;
        cSignatuurOrde4 = nArray4;
        cSignatuurOrde5 = new int[16];
    }
}

