/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;

final class StatusView
extends Canvas
implements Observer {
    Solver ivSolver;
    int ivStatus;
    int ivNumSolutions;
    String[] ivStatusText = new String[]{"Not Ready", "Ready to Run", "Running", "Completed; elapsed time ", "Aborted", "Initialization error", "Aborted with error"};
    int ivElapsedTime;
    long ivGeplaatst;
    static final int ivLeftBorder = 4;

    StatusView(Solver solver, Color color) {
        this.ivSolver = solver;
        this.setBackground(color);
        this.ivSolver.addObserver(this);
        this.ivSolver.ivClock.addObserver(this);
        Font font = null;
        font = new Font("Helvetica", 0, 10);
        if (font == null && (font = new Font("SansSerif", 0, 10)) == null) {
            font = new Font("Dialog", 0, 10);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    public synchronized void paintSpeed(Graphics graphics) {
        String string;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, (n += 2 * (fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading())) - fontMetrics.getAscent(), this.size().width, fontMetrics.getAscent() + fontMetrics.getDescent());
        graphics.setColor(Color.black);
        double d = 0.0;
        if (this.ivElapsedTime > 0) {
            int n2 = (int)(100.0 * (double)this.ivGeplaatst / (double)this.ivElapsedTime + 0.5);
            d = (double)n2 / 100.0;
        }
        if ((string = Double.toString(d)).charAt(string.length() - 2) == '.') {
            string = String.valueOf(string) + "0";
        }
        graphics.drawString("Tried " + this.ivGeplaatst + " pieces at " + string + " per second", 4, n);
    }

    public synchronized void paintStatus(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, (n += fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading()) - fontMetrics.getAscent(), this.size().width, fontMetrics.getAscent() + fontMetrics.getDescent());
        graphics.setColor(Color.black);
        StringBuffer stringBuffer = new StringBuffer(this.ivStatusText[this.ivStatus]);
        if (this.ivStatus == 3) {
            stringBuffer.append(this.ivElapsedTime).append(" seconds");
        }
        stringBuffer.append("; number of solutions ").append(this.ivNumSolutions);
        graphics.drawString(stringBuffer.toString(), 4, n);
    }

    public synchronized void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() + fontMetrics.getLeading();
        graphics.drawString("Polyomino Puzzle Solver 1.4, \u00a91998-1999 by Gerard Putter", 4, n);
        this.paintStatus(graphics);
        this.paintSpeed(graphics);
    }

    public synchronized void update(Observable observable, Object object) {
        block9: {
            int n;
            block6: {
                block8: {
                    int n2;
                    block7: {
                        if (!(observable instanceof Solver)) break block6;
                        n2 = ((SolverEvent)object).ivWhat;
                        if (n2 != 1) break block7;
                        this.ivStatus = ((SolverEvent)object).ivData;
                        Graphics graphics = this.getGraphics();
                        if (graphics != null) {
                            this.paintStatus(graphics);
                            return;
                        }
                        break block8;
                    }
                    if (n2 != 2) break block9;
                    this.ivNumSolutions = ((SolverEvent)object).ivData;
                    Graphics graphics = this.getGraphics();
                    if (graphics == null) break block9;
                    this.paintStatus(graphics);
                }
                return;
            }
            if (observable instanceof Clock && ((n = ((ClockEvent)object).ivWhat) == 1 || n == 3)) {
                this.ivElapsedTime = ((ClockEvent)object).ivTime;
                this.ivGeplaatst = this.ivSolver.GetTotaalGeplaatst();
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    this.paintSpeed(graphics);
                }
            }
        }
    }
}

